module net.BurtonRadons.dig.platform.checkBox;

private import net.BurtonRadons.dig.platform.control;

//private import std.c.stdio;


/** This widget has a toggleable checkbox and a text label. */
class CheckBox : Control
{
    private import net.BurtonRadons.dig.platform.base;
    
    Dispatcher onClick; /**< Dispatched when the checkbox is clicked upon. */
    Dispatcher onDClick; /**< Dispatched when the checkbox is double-clicked upon; if this is empty, #onClick is used instead. */

    /** Register with the parent control and create the widget. */
    this (Control parent)
    {
        super (parent);
        digPlatformStyle |= std.c.windows.windows.WS_VISIBLE | std.c.windows.windows.WS_CHILD | std.c.windows.windows.BS_NOTIFY | std.c.windows.windows.BS_CHECKBOX;
        digPlatformStyle &= ~(std.c.windows.windows.WS_HSCROLL | std.c.windows.windows.WS_VSCROLL);
        digPlatformHWNDCreate (0, "BUTTON", null, digPlatformStyle, (_HANDLE) 0);
    }

    /** Change the textual caption in the checkbox.
      * Text where & is followed by a character is interpreted
      * specially to underline that character (but has no higher-level
      * effects).
      */

    void caption (char [] text)
    {
        if (digPlatformBoundLetter [0])
            bindings.remove (digPlatformBoundLetter, &onClick);

        digPlatformSetCaption (text);
        recalculate ();

        int offset = std.string.find (text, '&');

        if (offset >= 0)
        {
            digPlatformBoundLetter [0] = text [offset + 1];
            bind (digPlatformBoundLetter, &onClick);
        }
    }

    /** Set the text caption using formatting. */
    extern (C)
    void formatCaption (char [] text, ...)
    {
        formatCaption (text, cast (std.c.stdio.va_list) (&text + 1));
    }

    /** Set the text caption using formatting. */
    void formatCaption (char [] text, std.c.stdio.va_list args)
    {
        char buffer [2048];
        int length;

        length = std.c.stdio.vsprintf (buffer, text, args);
        caption (buffer [0 .. length]);
    }

    /** Set whether this checkbox is checked or not. */
    void checked (bit value)
    {
        SendMessageA (digPlatformHWND, std.c.windows.windows.BM_SETCHECK, value ? std.c.windows.windows.BST_CHECKED : std.c.windows.windows.BST_UNCHECKED, 0);
    }

    /** Return whether this checkbox is checked or not. */
    bit checked ()
    {
        int result = SendMessageA (digPlatformHWND, std.c.windows.windows.BM_GETCHECK, 0, 0);

        return result == std.c.windows.windows.BST_CHECKED;
    }

    /** Set whether this is active (true) or grayed and inactive (false). */
    void enabled (bit value)
    {
        EnableWindow (digPlatformHWND, value);
    }

    /** If set, the text inside the checkbox is aligned to the left border; otherwise it is centered. */
    void alignLeft (bit value) { digPlatformSetStyle (std.c.windows.windows.BS_LEFT, value); }

    /** If set, the text inside the checkbox is aligned to the right border; otherwise it is centered. */
    void alignRight (bit value) { digPlatformSetStyle (std.c.windows.windows.BS_RIGHT, value); }

    /** If set, the text inside the checkbox is aligned to the top; otherwise it is vertically centered. */
    void alignTop (bit value) { digPlatformSetStyle (std.c.windows.windows.BS_TOP, value); }

    override void recalculate ()
    {
        _HGDIOBJ font;
        _DWORD result;

        font = (_HANDLE) SendMessageA (digPlatformHWND, WM_GETFONT, 0, 0);
        SelectObject (digPlatformHDC, font);
        result = GetTabbedTextExtentW (digPlatformHDC, digPlatformCaption, digPlatformCaption.length, 0, null);
        digPlatformSuggestWidth = (result & 0xFFFF) + 20;
        digPlatformSuggestHeight = result >> 16;
        digPlatformBorder (digPlatformSuggestWidth, digPlatformSuggestHeight);
        digPlatformMoved ();
    }

/+
#ifdef DoxygenMustSkipThis
+/

    char [1] digPlatformBoundLetter; /**< The letter that this is bound to, or \0 for none. */
    
    void digPlatformBorder (inout int width, inout int height)
    {
        width += 20;
        height += 6;
    }

    override void digPlatformCommand (int code, int id)
    {
        switch (code)
        {
            case std.c.windows.windows.BN_CLICKED: onClick.notify (); break;
            case std.c.windows.windows.BN_DBLCLK: onClick.notifyOrEmpty (&onDClick); break;
            case std.c.windows.windows.BN_KILLFOCUS: break;
            case std.c.windows.windows.BN_SETFOCUS: break;
            default:
                printf ("not handled: %d %d\n", code, id);
        }
    }
    
/+
#endif
+/
}

